;
;								EJEMPLO 17
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;El manejo de la pantalla LCD
;
;Este ejemplo pretende introducirnos en el manejo de la pantalla LCD, para la visualizacin
;de diferentes mensajes.
;
		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos
   
;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

			__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC
                 		
Lcd_var		equ	0x20		;Variables (2) de las rutinas de manejo del LCD
Delay_Cont	equ	0x22		;Variable para la temporizacin
Temporal_1	equ	0x23		;Variable temporal
Temporal_2	equ	0x24		;Variable temporal

		
			org	0x00				;Vector de RESET	
			goto	Inicio
			org	0x05

			include	"LCD_Cxx.inc"	;Incluye las rutinas de manejo del LCD

;******************************************************************************************
;Segn el valor contenido en el registro W, se devuelve el carcter a visualizar

Tabla_Mensajes	movwf	PCL			;Calcula el desplazamiento sobre la tabla

Mens_0			equ	$				;Mens_0 apunta al primer carcter del mensaje 0
				retlw	'H'
				retlw	'o'
				retlw	'l'
				retlw	'a'
				retlw	0x00		;Ultimo carcter del mensaje 0

Mens_1			equ	$				;Mens_1 apunta al primer carcter del mensaje 1
				retlw	'A'
				retlw	'd'
				retlw	'i'
				retlw	'o'
				retlw	's'
				retlw	0x00		;Ultimo carcter del mensaje 1
	
;*********************************************************************************
;Delay_var: Esta rutina de propsito general realiza una temporizacin variable
;entre 10 mS y 2.5". Se emplea un preescaler de 256 y al TMR0 se le carga con 39. 
;La velocidad de trabajo es de 4Mhz y por tanto el TMR0 se incrementa cada 1uS. De 
;esta forma, el TMR0 debe contar 39 eventos que, con un preescaler de 256 hace una
;intervalo total de 10000 uS (39 * 256 * 1). Este intervalo de 10 mS se repite tantes veces como 
;indique la variable "Delay_cont", es por ello que el delay mnimo es de 10 mS ("Delay_cont=1) 
;y el mximo de 2.5" (Delay_cont=255).

Delay_var:		bcf		INTCON,T0IF		;Desconecta el flag de rebosamiento
				movlw	~.39		
				movwf	TMR0			;carga el TMR0 con 39
Intervalo		btfss	INTCON,T0IF		;Rebasamiento del TMR0 ??
				goto	Intervalo		;Todava no		
				decfsz	Delay_Cont,F	;Decrementa contador de intervalos
				goto	Delay_var		;Repite el intervalo de 10 mS
				return	

;*************************************************************************************
;Mensaje: Esta rutina visualiza en el LCD el mensaje cuyo inicio est indicado en
;el acumulador. El fin de un mensaje se determina mediante el cdigo 0x00

Mensaje    		movwf   Temporal_1      ;Salva posicin de la tabla
Mensaje_1  		movf    Temporal_1,W    ;Recupera posicin de la tabla
          		call    Tabla_Mensajes	;Busca caracter de salida
           		movwf   Temporal_2      ;Guarda el caracter
          	 	movf    Temporal_2,F
            	btfss   STATUS,Z        ;Mira si es el ltimo
               	goto    No_es_ultimo
               	return
No_es_ultimo   	call    LCD_DATO        ;Visualiza en el LCD
               	incf    Temporal_1,F    ;Siguiente caracter
               	goto    Mensaje_1

Inicio	       	clrf 	PORTB			;Borra los latch de salida
				bsf		STATUS,RP0		;Selecciona banco 1
				clrf	TRISB			;Puerta B se configura como salida
				movlw	0x06
				movwf	ADCON1			;Puerta A digital
				movlw	b'00110001'		
				movwf	TRISA			;RA1-RA3 salidas				
				movlw	b'00000111'
				movwf	OPTION_REG		;Preescaler de 256 para el TMR0
				bcf		STATUS,RP0		;Selecciona banco 0			
				call	LCD_INI			;Secuencia de inicio del LCD
				movlw	b'00001100'
				call	LCD_REG			;Enva instruccin: LCD ON, Cursor OFF y blink OFF

Loop			movlw	b'00000001'
				call	LCD_REG			;Borra LCD y Home (colocar cursor en 1 posicin)
				movlw	Mens_0			;Carga el inicio del mensaje 0
				call	Mensaje			;Visualiza el mensaje 0
				movlw	.200
				movwf	Delay_Cont
				call	Delay_var		;Temporiza 2 segundos
				movlw	b'00000001'
				call	LCD_REG			;Borra LCD y Home (colocar cursor en 1 posicin)
				movlw	Mens_1
				call	Mensaje			;Visualiza el mensaje 1
				movlw	.200
				movwf	Delay_Cont
				call	Delay_var		;Temporiza 2 segundos
				goto	Loop

				end						;Fin del programa fuente

